/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.block_manipulation;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.Nullable;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.block_manipulation.BlockManipulationServer;
import qouteall.imm_ptl.core.platform_specific.IPRegistry;
import qouteall.imm_ptl.core.portal.Portal;
import qouteall.imm_ptl.core.portal.PortalUtils;

public class BlockManipulationClient {
    private static final Minecraft client = Minecraft.m_91087_();
    public static ResourceKey<Level> remotePointedDim;
    public static HitResult remoteHitResult;

    public static boolean isPointingToPortal() {
        return remotePointedDim != null;
    }

    @Nullable
    public static ClientLevel getRemotePointedWorld() {
        if (remotePointedDim == null) {
            return null;
        }
        return ClientWorldLoader.getWorld(remotePointedDim);
    }

    private static BlockHitResult createMissedHitResult(Vec3 from, Vec3 to) {
        Vec3 dir = to.m_82546_(from).m_82541_();
        return BlockHitResult.m_82426_((Vec3)to, (Direction)Direction.m_122366_((double)dir.f_82479_, (double)dir.f_82480_, (double)dir.f_82481_), (BlockPos)BlockPos.m_274446_((Position)to));
    }

    private static boolean hitResultIsMissedOrNull(HitResult bhr) {
        return bhr == null || bhr.m_6662_() == HitResult.Type.MISS;
    }

    public static void updatePointedBlock(float tickDelta) {
        if (BlockManipulationClient.client.f_91072_ == null || BlockManipulationClient.client.f_91073_ == null || BlockManipulationClient.client.f_91074_ == null) {
            return;
        }
        remotePointedDim = null;
        remoteHitResult = null;
        if (MinecraftForge.EVENT_BUS.post((Event)new BlockManipulationServer.CantDoCrossPortalInteractionEvent((Player)BlockManipulationClient.client.f_91074_))) {
            return;
        }
        Vec3 cameraPos = BlockManipulationClient.client.f_91063_.m_109153_().m_90583_();
        float reachDistance = BlockManipulationClient.client.f_91072_.m_105286_();
        PortalUtils.raytracePortalFromEntityView((Entity)BlockManipulationClient.client.f_91074_, tickDelta, reachDistance, true, portal1 -> portal1.isInteractableBy((Player)BlockManipulationClient.client.f_91074_)).ifPresent(pair -> {
            Portal portal = (Portal)pair.getFirst();
            double distanceToPortalPointing = ((Vec3)pair.getSecond()).m_82554_(cameraPos);
            if (distanceToPortalPointing < BlockManipulationClient.getCurrentTargetDistance() + 0.2) {
                BlockManipulationClient.client.f_91077_ = BlockManipulationClient.createMissedHitResult(cameraPos, (Vec3)pair.getSecond());
                BlockManipulationClient.updateTargetedBlockThroughPortal(cameraPos, BlockManipulationClient.client.f_91074_.m_20252_(tickDelta), (ResourceKey<Level>)BlockManipulationClient.client.f_91074_.m_9236_().m_46472_(), distanceToPortalPointing, reachDistance, portal);
            }
        });
    }

    private static double getCurrentTargetDistance() {
        BlockPos hitPos;
        Vec3 cameraPos = BlockManipulationClient.client.f_91063_.m_109153_().m_90583_();
        if (BlockManipulationClient.hitResultIsMissedOrNull(BlockManipulationClient.client.f_91077_)) {
            return 23333.0;
        }
        if (BlockManipulationClient.client.f_91077_ instanceof BlockHitResult && BlockManipulationClient.client.f_91073_.m_8055_(hitPos = ((BlockHitResult)BlockManipulationClient.client.f_91077_).m_82425_()).m_60734_() == IPRegistry.NETHER_PORTAL_BLOCK.get()) {
            return 23333.0;
        }
        return cameraPos.m_82554_(BlockManipulationClient.client.f_91077_.m_82450_());
    }

    private static void updateTargetedBlockThroughPortal(Vec3 cameraPos, Vec3 viewVector, ResourceKey<Level> playerDimension, double beginDistance, double endDistance, Portal portal) {
        Vec3 from = portal.transformPoint(cameraPos.m_82549_(viewVector.m_82490_(beginDistance)));
        Vec3 to = portal.transformPoint(cameraPos.m_82549_(viewVector.m_82490_(endDistance)));
        ClipContext context = new ClipContext(from, to, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)BlockManipulationClient.client.f_91074_);
        ClientLevel world = ClientWorldLoader.getWorld(portal.dimensionTo);
        remoteHitResult = (HitResult)BlockGetter.m_151361_((Vec3)from, (Vec3)to, (Object)context, (rayTraceContext, blockPos) -> {
            BlockState blockState = world.m_8055_(blockPos);
            if (blockState.m_60734_() == IPRegistry.NETHER_PORTAL_BLOCK.get()) {
                return null;
            }
            if (blockState.m_60734_() == Blocks.f_50375_) {
                return null;
            }
            FluidState fluidState = world.m_6425_(blockPos);
            Vec3 start = rayTraceContext.m_45702_();
            Vec3 end = rayTraceContext.m_45693_();
            Vec3 correctedStart = start.m_82546_(end.m_82546_(start).m_82490_(0.0015));
            VoxelShape solidShape = rayTraceContext.m_45694_(blockState, (BlockGetter)world, blockPos);
            BlockHitResult blockHitResult = world.m_45558_(correctedStart, end, blockPos, solidShape, blockState);
            VoxelShape fluidShape = rayTraceContext.m_45698_(fluidState, (BlockGetter)world, blockPos);
            BlockHitResult fluidHitResult = fluidShape.m_83220_(start, end, blockPos);
            double d = blockHitResult == null ? Double.MAX_VALUE : rayTraceContext.m_45702_().m_82557_(blockHitResult.m_82450_());
            double e = fluidHitResult == null ? Double.MAX_VALUE : rayTraceContext.m_45702_().m_82557_(fluidHitResult.m_82450_());
            return d <= e ? blockHitResult : fluidHitResult;
        }, rayTraceContext -> {
            Vec3 vec3d = rayTraceContext.m_45702_().m_82546_(rayTraceContext.m_45693_());
            return BlockHitResult.m_82426_((Vec3)rayTraceContext.m_45693_(), (Direction)Direction.m_122366_((double)vec3d.f_82479_, (double)vec3d.f_82480_, (double)vec3d.f_82481_), (BlockPos)BlockPos.m_274446_((Position)rayTraceContext.m_45693_()));
        });
        if (BlockManipulationClient.remoteHitResult.m_82450_().f_82480_ < (double)world.m_141937_() + 0.1) {
            remoteHitResult = new BlockHitResult(remoteHitResult.m_82450_(), Direction.DOWN, ((BlockHitResult)remoteHitResult).m_82425_(), ((BlockHitResult)remoteHitResult).m_82436_());
        }
        if (remoteHitResult != null && !world.m_8055_(((BlockHitResult)remoteHitResult).m_82425_()).m_60795_()) {
            BlockManipulationClient.client.f_91077_ = BlockManipulationClient.createMissedHitResult(from, to);
            remotePointedDim = portal.dimensionTo;
        }
    }

    public static <T> T withSwitchedContext(Supplier<T> func, boolean transformHitResult) {
        HitResult effectiveHitResult;
        HitResult hitResult;
        Validate.notNull((Object)remoteHitResult);
        ClientLevel remoteWorld = BlockManipulationClient.getRemotePointedWorld();
        Validate.notNull((Object)remoteWorld);
        if (transformHitResult && (hitResult = remoteHitResult) instanceof BlockHitResult) {
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            Tuple<BlockHitResult, ResourceKey<Level>> r = BlockManipulationServer.getHitResultForPlacing((Level)remoteWorld, blockHitResult);
            effectiveHitResult = (HitResult)r.m_14418_();
            remoteWorld = ClientWorldLoader.getWorld((ResourceKey<Level>)((ResourceKey)r.m_14419_()));
            Validate.notNull((Object)remoteWorld);
            Validate.notNull((Object)effectiveHitResult);
        } else {
            effectiveHitResult = remoteHitResult;
        }
        return (T)ClientWorldLoader.withSwitchedWorld(remoteWorld, () -> {
            HitResult originalHitResult = BlockManipulationClient.client.f_91077_;
            BlockManipulationClient.client.f_91077_ = effectiveHitResult;
            try {
                Object t = func.get();
                return t;
            }
            finally {
                BlockManipulationClient.client.f_91077_ = originalHitResult;
            }
        });
    }

    @Nullable
    public static String getDebugString() {
        if (remotePointedDim == null) {
            return null;
        }
        HitResult hitResult = remoteHitResult;
        if (hitResult instanceof BlockHitResult) {
            BlockHitResult blockHitResult = (BlockHitResult)hitResult;
            return "Point:%s %d %d %d".formatted(remotePointedDim.m_135782_(), blockHitResult.m_82425_().m_123341_(), blockHitResult.m_82425_().m_123342_(), blockHitResult.m_82425_().m_123343_());
        }
        return null;
    }
}

